import { expect } from 'chai';
import { describe } from 'mocha';
import { deployContractsForTests, getSigners } from './helpers/deploy-helper';
import { Signers } from './types';
import { Governance } from '../../types';

describe('80 - Governance Contract Test', function () {
  let contract: Governance;
  let signers: Signers;
  beforeEach(async function () {
    contract = (await deployContractsForTests()).governanceContract;
    signers = await getSigners();
  });
  describe('Basic tests:', function () {
    it('contract can be deployed', async function () {
      await expect(contract).to.exist;
    });
  });

  describe('contract extends OpenZeppelin Ownable ', function () {
    it('should check contract owner', async function () {
      expect(await contract.owner()).to.equal(signers.admin.address);
    });
    it('owner can change the owner', async function () {
      await contract.transferOwnership(signers.signer1.address);
      expect(await contract.owner()).to.equal(signers.signer1.address);
    });
  });
});
